//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.IO;
using System.Xml;
using System.Xml.Xsl;
using System.Xml.XPath;

namespace FrameworkLibraries
{
	public class TransformXmlFile
	{
		public static void Main(string [] args)
		{
			string xmldocument = "booklist.xml";
			string xsldocument = "total-sales.xsl";
			TransformXmlFile transformXml = new TransformXmlFile();
			if ( args.Length > 1 ) 
			{
				transformXml.Process(args[0], args[1]);
			}
			else
				transformXml.Process(xmldocument, xsldocument);
		}

		public void Process(string document, string xsl)
		{
			XmlReader reader = null;
			try
			{
				XPathDocument myXPathDocument = new XPathDocument (document);
				XslTransform myXslTransform = new XslTransform();
				myXslTransform.Load(xsl);
				reader = myXslTransform.Transform(myXPathDocument, null);
				while (reader.Read())
				{
					Console.WriteLine(reader.Value);
				}
			}
			catch (Exception e)
			{
				Console.WriteLine ("Wyjtek: {0}", e.ToString());
			}
			finally
			{
				Console.WriteLine();
				Console.WriteLine("Zakoczono przetwarzanie pliku {0}.", document);
				// Zakoczono prac z XmlTextReader
				if (reader != null)
					reader.Close();
			}
		}
	}
}
